%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    Main MoM matrix for a parallel-plate capacitor


function A = matrixACap (EPS,dS,x,y,d)
N = length(x);

if (length(dS)== N)
    for i = 1 : N
        for j = 1 : N
            r1 = sqrt ((x(j)-x(i))^2 + (y(j)-y(i))^2 ); 
            r2 = sqrt ((x(j)-x(i))^2 + (y(j)-y(i))^2 + d^2); 
            if (i==j)
                A(i,j) = sqrt(dS(j))/(2*sqrt(pi)*EPS)- dS(j)/(4*pi*EPS*r2);
            else
                A(i,j) = dS(j)/(4*pi*EPS*r1) - dS(j)/(4*pi*EPS*r2);
            end;
        end;
    end;
else
    A = 0;
    disp ('Incorrect input data in function matrixACap');
end;
